function [av_all_episodes]=simulation_rep(alpha,beta,T1,Ts,T2,Deltav2,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K)

%This function returns av_all_episodes, a (T1+Ts+T2)x(6*N+2) matrix containing for each episode t the mean across experiments 
%of A_N (quoted price of AMM N), the mean of opt_N (greedy price of AMM N),
%the mean of Profit_N (profit of AMM N), the mean of a_min (lowest quoted price), 
%and the means of the same variables squared. 

%In the case N=2 for instance the columns of av_all_episodes are ordered as follows:
%1: mean(A_1)
%2: mean(A_2)
%3: mean(opt_1)
%4: mean(opt_2)
%5: mean(Profit_1)
%6: mean(Profit_2)
%7: mean(a_min)
%8: mean(A_1^2)
%9: mean(A_2^2)
%10: mean(opt_1^2)
%11: mean(opt_2^2)
%12: mean(Profit_1^2)
%13: mean(Profit_2^2)
%14: mean(a_min^2)

%Initialize
av_all_episodes = zeros(T1+Ts+T2,6*N+2);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.
parfor k=1:K
    [all_episodes] = simulation_exp(alpha,beta,T1,Ts,T2,Deltav2,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N)
    %Adds the values of all episodes to the existing av_all_episodes
    av_all_episodes = av_all_episodes + all_episodes;
    %Uncomment the next line to follow the execution of the code
    %disp(k)
end

%Divide av_all_episodes by K to get the average across all experiments:
av_all_episodes = av_all_episodes/K;
